<?php

    use Firebase\JWT\JWT;
    use Firebase\JWT\Key;

    require 'assets/plugins/php-jwt-main/src/JWT.php';
    require 'assets/plugins/php-jwt-main/src/Key.php';

	function FCM($uniqueId, $title, $message, $bigImage, $link, $postId, $fcmServerKey, $fcmNotificationTopic) {

		$data = array(
			'to' => '/topics/' . $fcmNotificationTopic,
			'data' => array(
				'title' => $title,
				'message' => $message,
				'big_image' => $bigImage,
				'link' => $link,
				'post_id' => $postId,
				"unique_id"=> $uniqueId
			)
		);

		$header = array(
			'Authorization: key=' . $fcmServerKey,
			'Content-Type: application/json'
		);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$result = curl_exec($ch);

		if (curl_errno($ch)) {
			echo json_encode(false);
		} else {
			echo json_encode(true);
		}

		curl_close($ch);

		$_SESSION['msg'] = "FCM push notification sent...";
		header('Location:push.php');
		exit; 

	}

    function FCM_V1($uniqueId, $title, $message, $bigImage, $link, $postId, $OAuthKey, $fcmNotificationTopic) {

        $projectId = getFirebaseProjectId();
        $url = 'https://fcm.googleapis.com/v1/projects/'.$projectId.'/messages:send';

        $notification = array(
            "message" => array(
                "topic" => $fcmNotificationTopic,
                "notification" => array(
                    "title" => $title,
                    "body" => $message,
                    "image" => $bigImage
                ),
                "data" => array(
                    'title' => $title,
                    'message' => $message,
                    'big_image' => $bigImage,
                    'link' => $link,
                    'post_id' => $postId,
                    'unique_id' => $uniqueId
                ),
                "android" => array(
                    "notification" => array(
                    "click_action" => "OPEN_MAIN_ACTIVITY",
                    )
                )
            )
        );

        $header = array(
            'Authorization: Bearer ' . $OAuthKey,
            'Content-Type: application/json'
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($notification));
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            echo json_encode(false);
        } else {
            echo json_encode(true);
        }

        curl_close($ch);

        $_SESSION['msg'] = "FCM push notification sent...";
		header('Location:push.php');
        exit; 

    }

	function ONESIGNAL($uniqueId, $title, $message, $bigImage, $link, $postId, $oneSignalAppId, $oneSignalRestApiKey) {

		$content = array("en" =>  $message);

		$fields = array(
			'app_id' => $oneSignalAppId,
			'included_segments' => array('All'),                                            
			'data' => array(
				"foo" => "bar",
				"link" => $link,
				"post_id" => $postId,
				"unique_id" => $uniqueId
			),
			'headings'=> array("en" => $title),
			'contents' => $content,
			'big_picture' => $bigImage,     
			'url' => $link
		);

		$fields = json_encode($fields);
		print("\nJSON sent:\n");
		print($fields);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
			'Authorization: Basic '. $oneSignalRestApiKey));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_HEADER, FALSE);
		curl_setopt($ch, CURLOPT_POST, TRUE);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

		$response = curl_exec($ch);
		curl_close($ch);

		$_SESSION['msg'] = "OneSignal push notification sent...";
		header('Location:push.php');
		exit;       

	}

    function getFirebaseOAuthToken() {

        $jsonInfo = json_decode(file_get_contents("service-account.json"), true);

        $now_seconds = time();
        
        $privateKey = $jsonInfo['private_key'];
        
        $payload = [
            'iss' => $jsonInfo['client_email'],
            'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
            'aud' => $jsonInfo['token_uri'],
            //Token to be expired after 1 hour
            'exp' => $now_seconds + (60 * 60),
            'iat' => $now_seconds
        ];
        
        $jwt = JWT::encode($payload, $privateKey, 'RS256');
        
        // create curl resource
        $ch = curl_init();
        
        // set post fields
        $post = [
            'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
            'assertion' => $jwt
        ];
        
        $ch = curl_init($jsonInfo['token_uri']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        // execute!
        $response = curl_exec($ch);
        
        // close the connection, release resources used
        curl_close($ch);
        
        // do anything you want with your response
        $jsonObj = json_decode($response, true);

        return $jsonObj['access_token'];
    }

    function getFirebaseProjectId() {
        if (file_exists("service-account.json")) {
            $actualLink = (isset($_SERVER['HTTPS']) ? 'https' : 'http').'://'.$_SERVER['SERVER_NAME'].dirname($_SERVER['REQUEST_URI']);
            $url = $actualLink. "/service-account.json";
            $curl = curl_init($url);
            $header = array();
            $header[] = 'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:41.0) Gecko/20100101 Firefox/41.0';
            $header[] = 'timeout: 20';
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_HTTPHEADER,$header);
            $envatoRes = curl_exec($curl);
            curl_close($curl);
            $envatoRes = json_decode($envatoRes);
            $projectId = $envatoRes->project_id;
            if(is_null($projectId)) {
                return 'invalid';
            } else {
                return $projectId;
            }
        } else {
            return "invalid";
        }
    }

?>